package com.hero.objects.modifiers;

import org.jdom.Element;

import com.hero.objects.Adder;
import com.hero.objects.GenericObject;
import com.hero.objects.powers.Healing;

/**
 * Copyright (c) 2000 - 2005, CompNet Design, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, is prohibited unless the following conditions are met: 1.
 * Express written consent of CompNet Design, Inc. is obtained by the developer.
 * 2. Redistributions must retain this copyright notice. THIS SOFTWARE IS
 * PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * @author CompNet Design, Inc.
 * @version $Revision$
 */

public class DelayedReturnRate extends Modifier {

	private static String xmlID = "DELAYEDRETURNRATE";

	public DelayedReturnRate(Element root) {
		super(root, DelayedReturnRate.xmlID);
	}

	@Override
	public String getColumn2Output() {
		String adderString = "";
		String ret = "";
		ret += getAlias();
		double val = getTotalValue();
		for (Adder ad : getAssignedAdders()) {
			if (adderString.length() > 0) {
				adderString += ", ";
			}
			adderString += ad.getColumn2Output() + " ("
					+ getFraction(ad.getBaseCost()) + ")";
			val -= ad.getBaseCost();
		}
		if (getSelectedOption() != null) {
			ret += " (" + getSelectedOption().getAlias();
		} else {
			ret += " (";
		}
		if ((getInput() != null) && (getInput().trim().length() > 0)) {
			if (ret.trim().length() > 0) {
				ret += " ";
			}
			ret += getInput();
		}
		for (Modifier mod : getAssignedModifiers()) {
			ret += ", " + mod.getAlias();
		}
		int index = 0;
		int parenCount = 0;
		while (ret.indexOf("(", index) >= 0) {
			parenCount++;
			index = ret.indexOf("(", index) + 1;
		}
		index = 0;
		while (ret.indexOf(")", index) >= 0) {
			parenCount--;
			index = ret.indexOf(")", index) + 1;
		}
		if (parenCount <= 0) {
			ret += " (";
		} else {
			ret += "; ";
		}
		if (getComments().trim().length() > 0) {
			ret += getComments() + "; ";
		}
		ret += getFraction(val) + ")";
		parenCount--;
		while (parenCount > 0) {
			ret += ")";
			parenCount--;
		}
		if (adderString.trim().length() > 0) {
			if (ret.trim().length() > 0) {
				ret += ", ";
			}
			ret += adderString;
		}
		return ret;
	}

	@Override
	public String included(GenericObject o) {
		String ret = super.included(o);
		if (ret.trim().length() > 0) {
			return ret;
		}

        if (forceAllow()) return ret;
		if (o instanceof Healing) {
			return o.getDisplay()
					+ " has no return/fade rate (its effects are permanent).";
		} else {
			return "";
		}
	}
}